package com.zebra.zebrascannerdemo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import com.zebra.zebrascanner.ZebraScanner;
import com.zebra.zebrascanner.ZebraUtils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;

public class MainActivity extends Activity implements View.OnClickListener, ZebraScanner.DecodeCallback {
    private final static String TAG = "ZebraScannerDemo";
    final static private String getLastDecodedFilePath = "/sdcard/getLastDecodedImage1";
    private ZebraScanner mZebraScanner = null;
    private ZebraUtils mZebraUtils;
    private String sdlPropModelNum;
    private String sdlPropSerialNum;
    private String sdlPropImgKitVer;
    private String sdlPropEngineVer;
    private int sdlPropHorizontalRes;
    private int sdlPropVerticalRes;

    private Button startDecode;
    private Button getPvalue;
    private Button setPvalue;
    private Button defaultParamsButton;
    private Button decodedImageButton;

    private Spinner mSpinnerDecodeModes;
    private SharedPreferences sharedPref;
    private int decodeMode;

    private TextView scanResultContext;
    private EditText editPnum;
    private EditText editPvalue;
    private int motionEvents = 0;
    private int modechgEvents = 0;
    private static boolean isDecoding;
    private int testCount = 1;
    private long startTime = 0;
    private long endTime = 0;
    private static int decCount = 0;

    final static private int HANDLER_MSG_WHAT_DECODE_COMPLETE = 0x01;
    final static private int HANDLER_MSG_WHAT_DECODE_TIMEOUT = 0x02;
    final static private int HANDLER_MSG_WHAT_START_RECV_THREAD = 0x03;
    final static private int HANDLER_MSG_WHAT_GET_PROPS = 0x04;
    final static private int HANDLER_MSG_WHAT_STOP_DECODE = 0x05;

    private String samplesStr = "ME880S000741 ME880S000742 ME880S000743 ME880S000744 ME880S000745";
    private boolean bNeedContinueTest = true;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case HANDLER_MSG_WHAT_DECODE_COMPLETE:
                    Bundle b = msg.getData();
                    String displayData = "Type: " + mZebraUtils.getBarcodeTypeName(b.getInt("type")) + "\n";
                    displayData += "Length: " + b.getInt("length") + "\n";
                    displayData += "Decode Time: " + b.getInt("time") + "ms\n";
                    displayData += "Content: " + b.getString("data") + "\n";
                    scanResultContext.append(displayData);

                    if (samplesStr.indexOf(b.getString("data")) == -1) {
                        bNeedContinueTest = false;
                    }

                    if (decodeMode == 1 && bNeedContinueTest) {
                        scanResultContext.append("test count=" + testCount);
                        testCount++;
                        Message msgStartRecvThread = mHandler.obtainMessage();
                        msgStartRecvThread.what = HANDLER_MSG_WHAT_START_RECV_THREAD;
                        mHandler.sendMessageDelayed(msgStartRecvThread, 50);// 100ms
                    }

                    if (decCount == 0) {

                    }

                    break;
                case HANDLER_MSG_WHAT_DECODE_TIMEOUT:
                    scanResultContext.setText("Decode timeout !!");
                    break;
                case HANDLER_MSG_WHAT_START_RECV_THREAD:
                    bNeedContinueTest = true;
                    doDecode();
                    scanResultContext.setText("");
                    break;
                case HANDLER_MSG_WHAT_GET_PROPS:
                    sdlPropModelNum = mZebraScanner.sdlApiGetStrProperty(ZebraScanner.SDLPROP_MODEL_NUM);
                    sdlPropSerialNum = mZebraScanner.sdlApiGetStrProperty(ZebraScanner.SDLPROP_SERIAL_NUM);
                    sdlPropImgKitVer = mZebraScanner.sdlApiGetStrProperty(ZebraScanner.SDLPROP_IMGKIT_VER);
                    sdlPropHorizontalRes = mZebraScanner.sdlApiGetNumProperty(ZebraScanner.SDLPROP_HORIZONTAL_RES);
                    sdlPropVerticalRes = mZebraScanner.sdlApiGetNumProperty(ZebraScanner.SDLPROP_VERTICAL_RES);
                    String mProp = "Model:" + sdlPropModelNum + "\n";
                    mProp += "Serial:" + sdlPropSerialNum + "\n";
                    mProp += "ImgKit:" + sdlPropImgKitVer + "\n";
                    mProp += "Res:" + sdlPropHorizontalRes + " X " + sdlPropVerticalRes + "\n";
                    scanResultContext.setText(mProp);

                    break;
            }
        }
    };

    // Used to load the 'native-lib' library on application startup.
//    static {
//        System.loadLibrary("native-lib");
//    }

    private void viewInit() {
        sharedPref = getSharedPreferences("data", Context.MODE_PRIVATE);
        startDecode = findViewById(R.id.startDecode);
        getPvalue = findViewById(R.id.buttonGet);
        setPvalue = findViewById(R.id.buttonSet);
        defaultParamsButton = findViewById(R.id.buttonDfl);
        decodedImageButton = findViewById(R.id.buttonGetLastDecImg);

        editPnum = findViewById(R.id.editPnum);
        editPvalue = findViewById(R.id.editPval);
        scanResultContext = findViewById(R.id.scan_context);

        startDecode.setOnClickListener(this);
        getPvalue.setOnClickListener(this);
        setPvalue.setOnClickListener(this);
        defaultParamsButton.setOnClickListener(this);
        decodedImageButton.setOnClickListener(this);

        mSpinnerDecodeModes = findViewById(R.id.spinnerDecodeModes);
        mSpinnerDecodeModes.setSelection(sharedPref.getInt("decodeMode", 0));
        String str = mSpinnerDecodeModes.getSelectedItem().toString();

        if (str.equals("Normal"))
            decodeMode = 0;
        else if (str.equals("Test"))
            decodeMode = 1;

        mSpinnerDecodeModes.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
                SharedPreferences.Editor editor = sharedPref.edit();
                editor.putInt("decodeMode", pos);
                editor.commit();
                decodeMode = pos;
                Log.e(TAG, "position = " + pos);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // Another interface callback
            }
        });
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        viewInit();
        mZebraScanner = new ZebraScanner();
        mZebraUtils = new ZebraUtils();
        // Example of a call to a native method
        // scanResultContext.setText(mZebraScanner.stringFromJNI());
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.startDecode:
                Log.e(TAG, "onClick startDecode ...... ");
                if (mZebraScanner == null) {
                    break;
                }
                testCount = 0;
                Message msgStartRecvThread = mHandler.obtainMessage();
                msgStartRecvThread.what = HANDLER_MSG_WHAT_START_RECV_THREAD;
                mHandler.sendMessage(msgStartRecvThread);
                break;

            case R.id.buttonGet:
                Log.e(TAG, "parameter get ...... ");
                if (mZebraScanner == null || isDecoding) {
                    break;
                }
                String getPnum = editPnum.getText().toString();
                if (getPnum.isEmpty())
                    break;
                int getNum = Integer.parseInt(getPnum);
                int val = mZebraScanner.sdlApiGetNumParameter(getNum);
                if (val == -1)
                    scanResultContext.setText("get " + getNum + " value failed!");
                else {
                    scanResultContext.setText("get " + getNum + " value is  " + val);
                }

                break;
            case R.id.buttonSet:
                if (mZebraScanner == null || isDecoding) {
                    break;
                }
                String pNum = editPnum.getText().toString();
                if (pNum.isEmpty())
                    break;
                int setNum = Integer.parseInt(pNum);
                String pValue = editPvalue.getText().toString();
                if (pValue.isEmpty())
                    break;
                int setValue = Integer.parseInt(pValue);

                int ret = mZebraScanner.sdlApiSetNumParameter(setNum, setValue);
                if (ret == -1)
                    scanResultContext.setText("set " + setNum + " to " + setValue + " failed!");
                else
                    scanResultContext.setText("set " + setNum + " to " + setValue + " successfully!");

                break;
            case R.id.buttonDfl:
                if (mZebraScanner == null || isDecoding) {
                    break;
                }
                ret = mZebraScanner.sdlApiSetDefaultParameters();
                if (ret == -1)
                    scanResultContext.setText("set Default Parameters failed!");
                else
                    scanResultContext.setText("set Default Parameters successfully!");
                break;
            case R.id.buttonGetLastDecImg:
                byte[] imgData = mZebraScanner.sdlApiGetLastDecImage();
                if (imgData.length == 0) {
                    Log.e(TAG, "LastImageDecodeComplete: imgData null - no image");
                } else {
                    Log.e(TAG, "byte[] temp.size = " + imgData.length);
                    File imgFile = new File(getLastDecodedFilePath);
                    try {
                        FileOutputStream fous = new FileOutputStream(imgFile);
                        fous.write(imgData);
                        fous.flush();
                        fous.close();
                    } catch (FileNotFoundException e) {
                        e.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                    Intent mStartImageViewActivityIntent = new Intent(MainActivity.this, GetLastDecImage.class);
                    mStartImageViewActivityIntent.putExtra("data", getLastDecodedFilePath);
                    startActivity(mStartImageViewActivityIntent);
                }
                break;
            default:
                break;
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        isDecoding = false;
        Log.e(TAG, "onResume ..... ");
        int ret = mZebraScanner.openScanner(2);
        if (ret != ZebraScanner.BCR_SUCCESS) {
            mZebraScanner = null;
            Log.e(TAG, "mZebraScanner.sdlApiOpen = " + ret);
        } else {
            // init parameters
            mZebraScanner.sdlApiSetNumParameter(764, 5); // illumination level,max 10
            mZebraScanner.sdlApiSetNumParameter(136, 3); // decode session timeout ,max 9.9s

            if (false) { // enable the feature of getting last decoded images
                mZebraScanner.sdlApiSetNumParameter(905, 1); // enable this feature
                mZebraScanner.sdlApiSetNumParameter(304, 3); // bmp image
            }

            // get props
            Message msgGetProps = mHandler.obtainMessage();
            msgGetProps.what = HANDLER_MSG_WHAT_GET_PROPS;
            mHandler.sendMessage(msgGetProps);
            mZebraScanner.setDecodeCallback(this);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.e(TAG, "onPause ..... ");
        if (mZebraScanner != null) {
            isDecoding = false;
            int ret = mZebraScanner.sdlApiClose();
            Log.e(TAG, "sdlApiClose ret = " + ret);
        }
    }

    private void doDecode() {

        if (mZebraScanner == null)
            return;

        try {
            int ret = -1;
            startTime = System.currentTimeMillis();
            if (isDecoding) {
                ret = mZebraScanner.sdlApiStopDecode();
                if (ret != -1) {
                    isDecoding = false;
                }
            } else {
                ret = mZebraScanner.sdlApiStartDecode();
                if (ret != -1) {
                    isDecoding = true;
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void doStopDecode() {
        if (mZebraScanner != null && isDecoding) {
            int ret = mZebraScanner.sdlApiStopDecode();
            isDecoding = false;
            Log.e(TAG, "sdlApiStopDecode ret = " + ret);
        }

    }

    @Override
    public void onDecodeComplete(int symbology, int length, byte[] data, ZebraScanner reader) {
        Log.e(TAG, "symbology=" + symbology + ",length=" + length);
        // Get the decode count
        if (length == ZebraScanner.DECODE_STATUS_MULTI_DEC_COUNT) {
            decCount = symbology;
            return;
        }

        if (length > 0) {
            Log.i("TEST", "Decode Success ");
            endTime = System.currentTimeMillis();
            if (decCount-- > 0) {
                Message msg = mHandler.obtainMessage();
                msg.what = HANDLER_MSG_WHAT_DECODE_COMPLETE;
                Bundle bundle = new Bundle();
                bundle.putInt("type", symbology);
                bundle.putInt("length", length);
                bundle.putString("data", new String(data));
                bundle.putInt("time", (int) (endTime - startTime));
                msg.setData(bundle);
                mHandler.sendMessage(msg);
                if (decCount != 0)
                    return;
            }
        } else // no-decode
        {
            switch (length) {
                case ZebraScanner.DECODE_STATUS_TIMEOUT:
                    Log.d(TAG, "No Decode : decode timed out");
                    break;

                case ZebraScanner.DECODE_STATUS_CANCELED:
                    Log.d(TAG, "No Decode : decode cancelled");
                    break;

                case ZebraScanner.DECODE_STATUS_ERROR:
                default:
                    break;
            }
        }

        doStopDecode();

    }

    @Override
    public void onEvent(int event, int info, byte[] data, ZebraScanner reader) {
        switch (event) {
            case ZebraScanner.BCRDR_EVENT_SCAN_MODE_CHANGED:
                ++modechgEvents;
                Log.d(TAG, "Scan Mode Changed Event (#" + modechgEvents + ")");
                break;

            case ZebraScanner.BCRDR_EVENT_MOTION_DETECTED:
                ++motionEvents;
                Log.d(TAG, "Motion Detect Event (#" + motionEvents + ")");
                break;

            case ZebraScanner.BCRDR_EVENT_SCANNER_RESET:
                Log.d(TAG, "Reset Event"); // No need to display this event
                break;

            default:
                // process any other events here
                break;
        }
    }

}
